#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll key;
    ll x;
} Point;

int cmp(const void *a, const void *b) {
    Point *p = (Point *)a;
    Point *q = (Point *)b;
    if (p->key != q->key)
        return (p->key < q->key) ? -1 : 1;
    if (p->x != q->x)
        return (p->x < q->x) ? -1 : 1;
    return 0;
}


ll count_pairs(Point *arr, int n) {
    qsort(arr, n, sizeof(Point), cmp);
    ll res = 0;

    int i = 0;
    while (i < n) {
        int j = i;
        
        while (j < n && arr[j].key == arr[i].key) j++;
        ll k = j - i;
        
        res += k * (k - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);

    Point *d1 = malloc(N * sizeof(Point));
    Point *d2 = malloc(N * sizeof(Point));

    for (int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        
        d1[i] = (Point){x - y, x}; 
        d2[i] = (Point){x + y, x}; 
    }

    ll result = 0;
    result += count_pairs(d1, N);
    result += count_pairs(d2, N);

    printf("%lld\n", result);

    free(d1);
    free(d2);
    return 0;
}